/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.flammpfeil.slashblade.client.renderer.model.BladeFirstPersonRender;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SlashBladeTEISR
extends BlockEntityWithoutLevelRenderer {
    public SlashBladeTEISR(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void m_108829_(ItemStack itemStackIn, ItemDisplayContext type, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!(itemStackIn.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        this.renderBlade(itemStackIn, type, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    boolean checkRenderNaked() {
        ItemStack mainHand = BladeModel.user.m_21205_();
        return !(mainHand.m_41720_() instanceof ItemSlashBlade);
    }

    private boolean renderBlade(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.NONE) {
            if (BladeModel.user == null) {
                Minecraft minecraftInstance = Minecraft.m_91087_();
                BladeModel.user = minecraftInstance.f_91074_;
            }
            boolean handle = false;
            boolean bl = BladeModel.user.m_5737_() == HumanoidArm.RIGHT ? transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : (handle = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
            if (handle) {
                BladeFirstPersonRender.getInstance().render(matrixStack, bufferIn, combinedLightIn);
            }
            return false;
        }
        try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
            matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
            if (transformType == ItemDisplayContext.GROUND) {
                matrixStack.m_252880_(0.0f, 0.15f, 0.0f);
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.005f);
            } else if (transformType == ItemDisplayContext.GUI) {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.008f, true);
            } else if (transformType == ItemDisplayContext.FIXED) {
                if (stack.m_41794_() && stack.m_41795_() instanceof BladeStandEntity) {
                    this.renderModel(stack, matrixStack, bufferIn, combinedLightIn);
                } else {
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
                }
            } else {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
            }
        }
        return true;
    }

    private void renderIcon(ItemStack stack, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, float scale) {
        this.renderIcon(stack, matrixStack, bufferIn, lightIn, scale, false);
    }

    private void renderIcon(ItemStack stack, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn, float scale, boolean renderDurability) {
        matrixStack.m_85841_(scale, scale, scale);
        EnumSet<SwordType> types = SwordType.from(stack);
        ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> this.stackDefaultModel(stack));
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        ResourceLocation textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
        String renderTarget = types.contains((Object)SwordType.BROKEN) ? "item_damaged" : "item_blade";
        BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
        BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        if (renderDurability) {
            WavefrontObject durabilityModel = BladeModelManager.getInstance().getModel(DefaultResources.resourceDurabilityModel);
            float durability = (float)stack.m_41773_() / (float)stack.m_41776_();
            matrixStack.m_252880_(0.0f, 0.0f, 0.1f);
            Color aCol = new Color(0.25f, 0.25f, 0.25f, 1.0f);
            Color bCol = new Color(10824803);
            int r = 0xFF & (int)Mth.m_14179_((float)aCol.getRed(), (float)bCol.getRed(), (float)durability);
            int g = 0xFF & (int)Mth.m_14179_((float)aCol.getGreen(), (float)bCol.getGreen(), (float)durability);
            int b = 0xFF & (int)Mth.m_14179_((float)aCol.getBlue(), (float)bCol.getBlue(), (float)durability);
            BladeRenderState.setCol(new Color(r, g, b));
            BladeRenderState.renderOverrided(stack, durabilityModel, "base", DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
            boolean isBroken = types.contains((Object)SwordType.BROKEN);
            matrixStack.m_252880_(0.0f, 0.0f, -2.0f * durability);
            BladeRenderState.renderOverrided(stack, durabilityModel, isBroken ? "color_r" : "color", DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
        }
    }

    private ResourceLocation stackDefaultModel(ItemStack stack) {
        String key;
        CompoundTag stateTag = stack.m_41698_("bladeState");
        String name = stateTag.m_128461_("ModelName");
        if (!(stack.m_41720_() instanceof ItemSlashBladeDetune) && !(key = stateTag.m_128461_("translationKey")).isBlank()) {
            ResourceLocation bladeName = ResourceLocation.m_135820_((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().m_7745_(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getModelName().toString();
            }
        }
        return !name.isBlank() ? ResourceLocation.m_135820_((String)name) : DefaultResources.resourceDefaultModel;
    }

    private ResourceLocation stackDefaultTexture(ItemStack stack) {
        String key;
        CompoundTag stateTag = stack.m_41698_("bladeState");
        String name = stateTag.m_128461_("TextureName");
        if (!(stack.m_41720_() instanceof ItemSlashBladeDetune) && !(key = stateTag.m_128461_("translationKey")).isBlank()) {
            ResourceLocation bladeName = ResourceLocation.m_135820_((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().m_7745_(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getTextureName().toString();
            }
        }
        return !name.isBlank() ? ResourceLocation.m_135820_((String)name) : DefaultResources.resourceDefaultTexture;
    }

    private void renderModel(ItemStack stack, PoseStack matrixStack, MultiBufferSource bufferIn, int lightIn) {
        String renderTarget;
        float scale = 0.003125f;
        matrixStack.m_85841_(scale, scale, scale);
        float defaultOffset = 130.0f;
        matrixStack.m_252880_(defaultOffset, 0.0f, 0.0f);
        EnumSet<SwordType> types = SwordType.from(stack);
        ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> this.stackDefaultModel(stack));
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        ResourceLocation textureLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
        Vec3 bladeOffset = Vec3.f_82478_;
        float bladeOffsetRot = 0.0f;
        float bladeOffsetBaseRot = -3.0f;
        Vec3 sheathOffset = Vec3.f_82478_;
        float sheathOffsetRot = 0.0f;
        float sheathOffsetBaseRot = -3.0f;
        boolean vFlip = false;
        boolean hFlip = false;
        boolean hasScabbard = true;
        if (stack.m_41794_() && stack.m_41795_() instanceof BladeStandEntity) {
            BladeStandEntity stand = (BladeStandEntity)stack.m_41795_();
            Item type = stand.currentType;
            Pose pose = stand.m_20089_();
            switch (pose.ordinal()) {
                case 0: {
                    vFlip = false;
                    hFlip = false;
                    break;
                }
                case 1: {
                    vFlip = true;
                    hFlip = false;
                    break;
                }
                case 2: {
                    vFlip = true;
                    hFlip = true;
                    break;
                }
                case 3: {
                    vFlip = false;
                    hFlip = true;
                    break;
                }
                case 4: {
                    vFlip = false;
                    hFlip = false;
                    hasScabbard = false;
                    break;
                }
                case 5: {
                    vFlip = false;
                    hFlip = true;
                    hasScabbard = false;
                }
            }
            if (type == SBItems.bladestand_1) {
                bladeOffset = Vec3.f_82478_;
                sheathOffset = Vec3.f_82478_;
            } else if (type == SBItems.bladestand_2) {
                bladeOffset = new Vec3(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vec3(-40.0, -27.0, 0.0) : new Vec3(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            } else if (type == SBItems.bladestand_v) {
                bladeOffset = new Vec3(-100.0, 230.0, 0.0);
                sheathOffset = new Vec3(-100.0, 230.0, 0.0);
                bladeOffsetRot = 80.0f;
                sheathOffsetRot = 80.0f;
            } else if (type == SBItems.bladestand_s) {
                if (hFlip) {
                    bladeOffset = new Vec3(60.0, -25.0, 0.0);
                    sheathOffset = new Vec3(60.0, -25.0, 0.0);
                } else {
                    bladeOffset = new Vec3(-60.0, -25.0, 0.0);
                    sheathOffset = new Vec3(-60.0, -25.0, 0.0);
                }
            } else if (type == SBItems.bladestand_1w) {
                bladeOffset = Vec3.f_82478_;
                sheathOffset = Vec3.f_82478_;
            } else if (type == SBItems.bladestand_2w) {
                bladeOffset = new Vec3(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new Vec3(-40.0, -27.0, 0.0) : new Vec3(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            }
        }
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
            renderTarget = types.contains((Object)SwordType.BROKEN) ? "blade_damaged" : "blade";
            matrixStack.m_85837_(bladeOffset.f_82479_, bladeOffset.f_82480_, bladeOffset.f_82481_);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(bladeOffsetRot));
            if (vFlip) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
                matrixStack.m_252880_(0.0f, 5.0f, 0.0f);
            }
            if (hFlip) {
                double offset = defaultOffset;
                matrixStack.m_85837_(-offset, 0.0, 0.0);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_85837_(offset, 0.0, 0.0);
            }
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(bladeOffsetBaseRot));
            BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        }
        if (hasScabbard) {
            msac = MSAutoCloser.pushMatrix(matrixStack);
            try {
                renderTarget = "sheath";
                matrixStack.m_85837_(sheathOffset.f_82479_, sheathOffset.f_82480_, sheathOffset.f_82481_);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(sheathOffsetRot));
                if (vFlip) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
                    matrixStack.m_252880_(0.0f, 5.0f, 0.0f);
                }
                if (hFlip) {
                    double offset = defaultOffset;
                    matrixStack.m_85837_(-offset, 0.0, 0.0);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    matrixStack.m_85837_(offset, 0.0, 0.0);
                }
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(sheathOffsetBaseRot));
                BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
            }
            finally {
                if (msac != null) {
                    msac.close();
                }
            }
        }
    }
}

